<?php
session_start();

/**
 * Função recursiva para remover um diretório e seus arquivos.
 */
function rrmdir($dir) {
    if (is_dir($dir)) {
        $objects = scandir($dir);
        foreach ($objects as $object) {
            if ($object != "." && $object != "..") {
                $path = $dir . "/" . $object;
                if (is_dir($path))
                    rrmdir($path);
                else
                    unlink($path);
            }
        }
        rmdir($dir);
    }
}

// Sistema de autenticação
if (!isset($_SESSION['admin_logged_in'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
        $username = trim($_POST['username']);
        $password = trim($_POST['password']);
        if ($username === 'admin' && $password === 'admin') {
            $_SESSION['admin_logged_in'] = true;
            header("Location: " . $_SERVER['PHP_SELF']);
            exit;
        } else {
            $login_error = "Usuário ou senha inválidos.";
        }
    }
    ?>
    <!DOCTYPE html>
    <html lang="pt-BR">
    <head>
        <meta charset="UTF-8">
        <title>Login</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            body {
                background: linear-gradient(to right, #007bff, #00a8ff);
                font-family: Arial, sans-serif;
                height: 100vh;
                display: flex;
                justify-content: center;
                align-items: center;
                margin: 0;
            }
            .login-box {
                background: white;
                padding: 20px;
                border-radius: 10px;
                box-shadow: 0 4px 8px rgba(0,0,0,0.2);
                width: 100%;
                max-width: 350px;
            }
            .login-box h2 {
                margin-bottom: 20px;
                color: #333;
                text-align: center;
            }
            .login-box input {
                width: 100%;
                padding: 10px;
                margin: 10px 0;
                border: 1px solid #ccc;
                border-radius: 5px;
            }
            .login-box input[type="submit"] {
                background: linear-gradient(45deg, #007bff, #00a8ff);
                color: white;
                border: none;
                font-weight: bold;
                cursor: pointer;
            }
            .error {
                color: red;
                text-align: center;
                font-size: 14px;
            }
        </style>
    </head>
    <body>
        <div class="login-box">
            <h2>Painel de Acesso</h2>
            <?php if(isset($login_error)) echo '<p class="error">' . htmlspecialchars($login_error) . '</p>'; ?>
            <form method="post">
                <input type="text" name="username" placeholder="Usuário" required>
                <input type="password" name="password" placeholder="Senha" required>
                <input type="submit" name="login" value="Entrar">
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Configurações iniciais e persistência
$configFile = __DIR__ . '/config.json';
if (file_exists($configFile)) {
    $config = json_decode(file_get_contents($configFile), true);
} else {
    $config = [
        "background" => "background.jpg",
        "character" => "character.png",
        "logo" => "logo.png",
        "vs_icon" => "vs.png",
        "card_background_color" => "#003399",
        "card_text_color" => "#FFFFFF",
        "championship_text_color" => "#FFDD00",
        "header_font_size" => 100,
        "card_dimensions" => [
            "width" => 450,
            "height" => 280,
            "margin" => 30,
            "cards_per_row" => 4
        ],
        "telegram" => [
            "botToken" => "",
            "chatId" => ""
        ]
    ];
    file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT));
}

// Atualiza configurações via POST
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_config'])) {
    $uploadFields = [
        'background_file' => 'background.jpg',
        'character_file' => 'character.png',
        'logo_file' => 'logo.png',
        'vs_icon_file' => 'vs.png'
    ];
    foreach ($uploadFields as $field => $filename) {
        if (isset($_FILES[$field]) && $_FILES[$field]['error'] === UPLOAD_ERR_OK) {
            move_uploaded_file($_FILES[$field]['tmp_name'], __DIR__ . '/' . $filename);
            $config[str_replace('_file', '', $field)] = $filename;
        }
    }
    $config['card_background_color'] = $_POST['card_background_color'];
    $config['card_text_color'] = $_POST['card_text_color'];
    $config['championship_text_color'] = $_POST['championship_text_color'];
    $config['header_font_size'] = intval($_POST['header_font_size']);
    $config['card_dimensions']['width'] = intval($_POST['card_width']);
    $config['card_dimensions']['height'] = intval($_POST['card_height']);
    $config['card_dimensions']['margin'] = intval($_POST['card_margin']);
    $config['card_dimensions']['cards_per_row'] = intval($_POST['cards_per_row']);
    $config['telegram']['botToken'] = $_POST['telegram_botToken'];
    $config['telegram']['chatId'] = $_POST['telegram_chatId'];

    file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT));
    $_SESSION['msg'] = "Configurações salvas com sucesso!";
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Ações do Telegram
if (isset($_GET['enviar'])) {
    $mensagem = $_GET['enviar'] === 'hoje' ? "Jogos de hoje!" : "Jogos de amanhã!";
    $token = $config['telegram']['botToken'];
    $chats = explode(',', $config['telegram']['chatId']);
    foreach ($chats as $chat) {
        file_get_contents("https://api.telegram.org/bot{$token}/sendMessage?chat_id=" . trim($chat) . "&text=" . urlencode($mensagem));
    }
    $_SESSION['msg'] = "Mensagem enviada com sucesso!";
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

// Download dos banners
if (isset($_GET['download_banners'])) {
    $folder = __DIR__ . '/cartazes/';
    $zipname = 'banners.zip';
    if (!is_dir($folder)) die("Nenhum banner disponível.");
    $zip = new ZipArchive;
    if ($zip->open($zipname, ZipArchive::CREATE | ZipArchive::OVERWRITE)) {
        $files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($folder, FilesystemIterator::SKIP_DOTS));
        foreach ($files as $file) {
            $filePath = $file->getRealPath();
            $zip->addFile($filePath, basename($filePath));
        }
        $zip->close();
        header('Content-Type: application/zip');
        header('Content-Disposition: attachment; filename="' . $zipname . '"');
        header('Content-Length: ' . filesize($zipname));
        readfile($zipname);
        unlink($zipname);
        rrmdir($folder);
        exit;
    } else {
        die("Erro ao criar o ZIP.");
    }
}

include 'painel_ui.php';
