<?php
session_start();

/**
 * Função recursiva para remover um diretório e seus arquivos.
 */
function rrmdir($dir) {
    if (is_dir($dir)) {
        $objects = scandir($dir);
        foreach ($objects as $object) {
            if ($object != "." && $object != "..") {
                $path = $dir . "/" . $object;
                if (is_dir($path))
                    rrmdir($path);
                else
                    unlink($path);
            }
        }
        rmdir($dir);
    }
}

// Se o parâmetro download_banners estiver definido, cria um ZIP da pasta cartazes, envia para download e deleta a pasta.
if (isset($_GET['download_banners'])) {
    $folder = __DIR__ . '/cartazes/';
    if (!is_dir($folder)) {
        die("Nenhum banner gerado.");
    }
    $zipname = 'banners.zip';
    $zip = new ZipArchive;
    if ($zip->open($zipname, ZipArchive::CREATE | ZipArchive::OVERWRITE) === TRUE) {
        $files = new RecursiveIteratorIterator(
            new RecursiveDirectoryIterator($folder, FilesystemIterator::SKIP_DOTS),
            RecursiveIteratorIterator::LEAVES_ONLY
        );
        foreach ($files as $file) {
            if (!$file->isDir()) {
                $filePath = $file->getRealPath();
                $relativePath = ltrim(str_replace($folder, '', $filePath), DIRECTORY_SEPARATOR);
                $zip->addFile($filePath, $relativePath);
            }
        }
        $zip->close();
        header('Content-Type: application/zip');
        header('Content-Disposition: attachment; filename="'.$zipname.'"');
        header('Content-Length: ' . filesize($zipname));
        readfile($zipname);
        unlink($zipname);
        rrmdir($folder);
        exit;
    } else {
        die("Erro ao criar o arquivo ZIP.");
    }
}

// Sistema de autenticação para acessar o painel
if (!isset($_SESSION['admin_logged_in'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
        $username = trim($_POST['username']);
        $password = trim($_POST['password']);
        // Usuário e senha para acesso ao painel
        if ($username === 'admin' && $password === 'admin') {
            $_SESSION['admin_logged_in'] = true;
            header("Location: " . $_SERVER['PHP_SELF']);
            exit;
        } else {
            $login_error = "Usuário ou senha inválidos.";
        }
    }
    ?>
    <!DOCTYPE html>
    <html lang="pt-BR">
    <head>
        <meta charset="UTF-8">
        <title>Login - Painel Gerenciador</title>
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <style>
            body {
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                background-color: #f4f4f9;
                display: flex;
                align-items: center;
                justify-content: center;
                height: 100vh;
                margin: 0;
            }
            .login-container {
                background: #fff;
                padding: 20px;
                border-radius: 8px;
                box-shadow: 0 4px 8px rgba(0,0,0,0.1);
                width: 90%;
                max-width: 300px;
            }
            input[type="text"],
            input[type="password"] {
                width: 100%;
                padding: 8px;
                margin: 8px 0;
                border: 1px solid #ccc;
                border-radius: 4px;
            }
            input[type="submit"] {
                width: 100%;
                padding: 10px;
                background: linear-gradient(45deg, #007BFF, #00A8FF);
                border: none;
                color: #fff;
                border-radius: 4px;
                cursor: pointer;
            }
            .error { color: red; font-size: 14px; }
        </style>
    </head>
    <body>
        <div class="login-container">
            <h2>Painel Gerenciador - Login</h2>
            <?php if(isset($login_error)) echo '<p class="error">' . htmlspecialchars($login_error) . '</p>'; ?>
            <form method="post">
                <input type="text" name="username" placeholder="Usuário" required>
                <input type="password" name="password" placeholder="Senha" required>
                <input type="submit" name="login" value="Entrar">
            </form>
        </div>
    </body>
    </html>
    <?php
    exit;
}

// Carrega ou cria arquivo de configurações
$configFile = __DIR__ . '/config.json';
if (file_exists($configFile)) {
    $config = json_decode(file_get_contents($configFile), true);
} else {
    $config = [
        "background" => __DIR__ . '/background.jpg',
        "character" => __DIR__ . '/character.png',
        "logo" => __DIR__ . '/logo.png',
        "vs_icon" => __DIR__ . '/vs.png',
        "card_background_color" => "#003399",
        "card_text_color" => "#FFFFFF",
        "championship_text_color" => "#FFDD00",
        "header_font_size" => 100,
        "card_dimensions" => [
            "width" => 450,
            "height" => 280,
            "margin" => 30,
            "cards_per_row" => 4
        ],
        "telegram" => [
            "botToken" => "SEU_BOT_TOKEN_AQUI",
            "chatId" => "ID1,ID2,ID3"
        ]
    ];
    file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT));
}

// Bloco para envio de mensagens pelo Telegram
if (isset($_GET['enviar'])) {
    $tipo = $_GET['enviar'];
    // Define a mensagem com base no parâmetro recebido
    if ($tipo === 'hoje') {
        $mensagem = "Jogos de hoje: [conteúdo dos jogos de hoje aqui]";
    } elseif ($tipo === 'amanha') {
        $mensagem = "Jogos de amanhã: [conteúdo dos jogos de amanhã aqui]";
    } else {
        $mensagem = "Mensagem padrão";
    }
    // Recupera as configurações do Telegram
    $botToken = $config['telegram']['botToken'];
    $chatIds = explode(',', $config['telegram']['chatId']); // Separa os IDs por vírgula
    foreach ($chatIds as $chatId) {
        $chatId = trim($chatId); // Remove espaços em branco
        // Monta a URL da API do Telegram para enviar a mensagem
        $url = "https://api.telegram.org/bot{$botToken}/sendMessage?chat_id={$chatId}&text=" . urlencode($mensagem);
        file_get_contents($url);
    }
    $_SESSION['msg'] = "Mensagem enviada para o Telegram!";
    header("Location: " . $_SERVER['PHP_SELF']);
    exit;
}

$message = "";
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_config'])) {
    // Atualiza background
    if (isset($_FILES['background_file']) && $_FILES['background_file']['error'] === UPLOAD_ERR_OK) {
        $uploadPath = __DIR__ . '/background.jpg';
        if (move_uploaded_file($_FILES['background_file']['tmp_name'], $uploadPath)) {
            $config['background'] = $uploadPath;
        }
    }
    // Atualiza capa inicial
    if (isset($_FILES['character_file']) && $_FILES['character_file']['error'] === UPLOAD_ERR_OK) {
        $uploadPath = __DIR__ . '/capa.jpg';
        if (move_uploaded_file($_FILES['character_file']['tmp_name'], $uploadPath)) {
            $config['capa'] = $uploadPath;
        }
    }
    // Atualiza logo
    if (isset($_FILES['logo_file']) && $_FILES['logo_file']['error'] === UPLOAD_ERR_OK) {
        $uploadPath = __DIR__ . '/logo.png';
        if (move_uploaded_file($_FILES['logo_file']['tmp_name'], $uploadPath)) {
            $config['logo'] = $uploadPath;
        }
    }
    // Atualiza ícone VS
    if (isset($_FILES['vs_icon_file']) && $_FILES['vs_icon_file']['error'] === UPLOAD_ERR_OK) {
        $uploadPath = __DIR__ . '/vs.png';
        if (move_uploaded_file($_FILES['vs_icon_file']['tmp_name'], $uploadPath)) {
            $config['vs_icon'] = $uploadPath;
        }
    }
    // Atualiza demais configurações
    $config['card_background_color'] = $_POST['card_background_color'] ?? $config['card_background_color'];
    $config['card_text_color'] = $_POST['card_text_color'] ?? $config['card_text_color'];
    $config['championship_text_color'] = $_POST['championship_text_color'] ?? $config['championship_text_color'];
    $config['header_font_size'] = intval($_POST['header_font_size'] ?? $config['header_font_size']);
    $config['card_dimensions']['width'] = intval($_POST['card_width'] ?? $config['card_dimensions']['width']);
    $config['card_dimensions']['height'] = intval($_POST['card_height'] ?? $config['card_dimensions']['height']);
    $config['card_dimensions']['margin'] = intval($_POST['card_margin'] ?? $config['card_dimensions']['margin']);
    $config['card_dimensions']['cards_per_row'] = intval($_POST['cards_per_row'] ?? $config['card_dimensions']['cards_per_row']);
    // Atualiza configurações do Telegram
    $config['telegram']['botToken'] = $_POST['telegram_botToken'] ?? $config['telegram']['botToken'];
    $config['telegram']['chatId'] = $_POST['telegram_chatId'] ?? $config['telegram']['chatId'];
    
    file_put_contents($configFile, json_encode($config, JSON_PRETTY_PRINT));
    $message = "Configurações atualizadas com sucesso!";
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <title>Painel Gerenciador</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        /* Header com botão de configurações */
        #admin-header {
            background: #007BFF;
            color: #fff;
            padding: 15px;
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        #admin-header h1 {
            margin: 0;
            font-size: 24px;
        }
        #open-modal {
            background: #fff;
            color: #007BFF;
            border: none;
            padding: 8px 12px;
            border-radius: 4px;
            cursor: pointer;
            font-weight: bold;
        }
        /* Modal */
        .modal {
            display: none; 
            position: fixed;
            z-index: 1001;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0,0,0,0.4);
        }
        .modal-content {
            background-color: #fefefe;
            margin: 5% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 90%;
            max-width: 800px;
            border-radius: 8px;
            position: relative;
        }
        .close-modal {
            color: #aaa;
            font-size: 28px;
            font-weight: bold;
            cursor: pointer;
            position: absolute;
            top: 10px;
            right: 20px;
        }
        /* Estilização dos botões de ação */
        .btn {
            display: inline-block;
            margin: 10px 5px;
            padding: 10px 15px;
            background: linear-gradient(45deg, #007BFF, #00A8FF);
            color: #fff;
            text-decoration: none;
            border: none;
            border-radius: 4px;
            cursor: pointer;
        }
        /* Estilização geral do formulário */
        form {
            margin-top: 20px;
        }
        form h2 {
            margin-bottom: 10px;
            color: #333;
        }
        label {
            display: block;
            margin: 10px 0 5px;
            color: #555;
        }
        input[type="text"],
        input[type="number"],
        input[type="file"],
        input[type="color"] {
            width: 100%;
            padding: 8px;
            box-sizing: border-box;
            border: 1px solid #ccc;
            border-radius: 4px;
        }
        input[type="submit"] {
            margin-top: 20px;
            padding: 12px 20px;
            background: linear-gradient(45deg, #007BFF, #00A8FF);
            color: #fff;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-size: 16px;
        }
        input[type="submit"]:hover,
        .btn:hover {
            opacity: 0.9;
        }
        .message {
            text-align: center;
            color: green;
            font-size: 18px;
        }
    </style>
</head>
<body>
    <!-- Header com botão para abrir o modal de opções -->
    <header id="admin-header">
        <h1>Painel Gerenciador</h1>
        <button id="open-modal">Opções</button>
    </header>

    <!-- Exibição de mensagens -->
    <?php
    if (isset($_SESSION['msg'])) {
        echo '<p class="message">' . htmlspecialchars($_SESSION['msg']) . '</p>';
        unset($_SESSION['msg']);
    }
    if ($message) {
        echo '<p class="message">' . $message . '</p>';
    }
    ?>

    <!-- Modal com links de ação e formulário de configurações -->
    <div id="modal-options" class="modal">
        <div class="modal-content">
            <span class="close-modal">&times;</span>
            <!-- Seção de Ações -->
            <div class="modal-actions">
                <a class="btn" href="main.php?enviar=hoje">Enviar Jogos de Hoje</a>
                <a class="btn" href="main.php?enviar=amanha">Enviar Jogos de Amanhã</a>
                <a class="btn" href="main.php?destaques=true">Gerar Banner de Destaques</a>
                <a class="btn" href="main.php?download_zip=1">Baixar Banners Prontos</a>
            </div>
            <!-- Formulário de Configurações -->
            <form method="post" enctype="multipart/form-data">
                <h2>Configurações Gerais</h2>
                <label for="background_file">Atualizar Background:</label>
                <input type="file" name="background_file" id="background_file" accept="image/*">
                
                <label for="character_file">Atualizar Capa Inicial:</label>
                <input type="file" name="character_file" id="character_file" accept="image/*">
                
                <label for="logo_file">Atualizar Logo:</label>
                <input type="file" name="logo_file" id="logo_file" accept="image/*">
                
                <label for="vs_icon_file">Atualizar Ícone VS (PNG):</label>
                <input type="file" name="vs_icon_file" id="vs_icon_file" accept="image/png">
                
                <label for="card_background_color">Cor de Fundo dos Cards:</label>
                <input type="color" name="card_background_color" id="card_background_color" value="<?php echo htmlspecialchars($config['card_background_color']); ?>">
                
                <label for="card_text_color">Cor do Texto dos Cards:</label>
                <input type="color" name="card_text_color" id="card_text_color" value="<?php echo htmlspecialchars($config['card_text_color']); ?>">
                
                <label for="championship_text_color">Cor do Texto dos Campeonatos:</label>
                <input type="color" name="championship_text_color" id="championship_text_color" value="<?php echo htmlspecialchars($config['championship_text_color'] ?? '#FFFFFF'); ?>">
                
                <label for="header_font_size">Tamanho da Fonte do Cabeçalho:</label>
                <input type="number" name="header_font_size" id="header_font_size" value="<?php echo htmlspecialchars($config['header_font_size']); ?>">
                
                <h2>Dimensões dos Cards</h2>
                <label for="card_width">Largura do Card:</label>
                <input type="number" name="card_width" id="card_width" value="<?php echo htmlspecialchars($config['card_dimensions']['width']); ?>">
                
                <label for="card_height">Altura do Card:</label>
                <input type="number" name="card_height" id="card_height" value="<?php echo htmlspecialchars($config['card_dimensions']['height']); ?>">
                
                <label for="card_margin">Margem entre Cards:</label>
                <input type="number" name="card_margin" id="card_margin" value="<?php echo htmlspecialchars($config['card_dimensions']['margin']); ?>">
                
                <label for="cards_per_row">Cards por Linha:</label>
                <input type="number" name="cards_per_row" id="cards_per_row" value="<?php echo htmlspecialchars($config['card_dimensions']['cards_per_row']); ?>">
                
                <h2>Configurações do Telegram</h2>
                <label for="telegram_botToken">Token do Bot do Telegram:</label>
                <input type="text" name="telegram_botToken" id="telegram_botToken" value="<?php echo htmlspecialchars($config['telegram']['botToken']); ?>">
                
                <label for="telegram_chatId">Chat ID do Telegram (separe múltiplos por vírgula):</label>
                <input type="text" name="telegram_chatId" id="telegram_chatId" value="<?php echo htmlspecialchars($config['telegram']['chatId']); ?>">
                
                <input type="submit" name="update_config" value="Atualizar Configurações">
            </form>
        </div>
    </div>

    <script>
        const openModal = document.getElementById('open-modal');
        const modal = document.getElementById('modal-options');
        const closeModal = document.querySelector('.close-modal');

        openModal.addEventListener('click', function() {
            modal.style.display = 'block';
        });
        closeModal.addEventListener('click', function() {
            modal.style.display = 'none';
        });
        window.addEventListener('click', function(event) {
            if (event.target == modal) {
                modal.style.display = 'none';
            }
        });
    </script>
</body>
</html>
